<?php $__env->startSection('title'); ?> Inicio <?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- this is breadcrumbs -->
<?php $__env->startComponent('components.breadcrumb'); ?>
<?php $__env->slot('li_1'); ?> Inicio <?php $__env->endSlot(); ?>
<?php $__env->slot('li_2'); ?> Panel Tramite Documentario <?php $__env->endSlot(); ?>
<?php $__env->slot('title'); ?> Tramites Recibidos <?php $__env->endSlot(); ?>
<?php echo $__env->renderComponent(); ?>

<!-- start page content -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-body mb-n3">
                
                <p>Área actual del usuario: <?php echo e(auth()->user()->area_id); ?></p>

                <div class="table-responsive">
                    <table id="tablaAreas" class="table table-striped mb-0 table-hover">
                        <thead>
                            <tr>
                                <th>ID</th>
                                <th>Estudiante</th>
                                <th>Tipo</th>
                                <th>Estado</th>
                                <th>Fecha</th>
                                <th>Documento</th>
                                <th>Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $tramites; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tramite): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($tramite->id); ?></td>
                                    <td><?php echo e($tramite->postulante->nombres); ?> <?php echo e($tramite->postulante->apellidos); ?></td>

                                    <td><?php echo e($tramite->tramite->nombre); ?></td>
                                    <td><?php echo e(ucfirst($tramite->estado)); ?></td>
                                    <td><?php echo e(\Carbon\Carbon::parse($tramite->fecha_solicitud)->format('d/m/Y H:i')); ?></td>
                                    <td class="text-center">
                                        <?php if($tramite->archivo): ?>
                                            <a href="<?php echo e(asset('tramites/' . $tramite->archivo)); ?>" target="_blank" class="btn btn-sm btn-outline-secondary">
                                                <i class="bi bi-file-earmark-text"></i>
                                            </a>
                                        <?php else: ?>
                                            <span class="text-muted">Sin archivo</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <button class="btn btn-outline-primary btn-sm" onclick="derivarTramite(<?php echo e($tramite->id); ?>)" title="Derivar">
                                            <i class="bi bi-arrow-right-circle"></i>
                                        </button>
                                        <button class="btn btn-outline-info btn-sm" onclick="verTrazabilidad(<?php echo e($tramite->id); ?>)" title="Ver trazabilidad">
                                            <i class="bi bi-clock-history"></i>
                                        </button>

                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>

                </div>
            </div>
            <!--end card-body-->
        </div>
        <!--end card-->
    </div>
    <!--end col-->
</div>


<!-- Modal para derivar trámite -->
<div class="modal fade" id="modalDerivar" tabindex="-1" aria-labelledby="modalDerivarLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form id="formDerivarTramite">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Derivar Trámite</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body">
          <input type="hidden" name="solicitud_id" id="inputSolicitudId">

          <div class="mb-3">
            <label for="area_destino_id" class="form-label">Área de destino</label>
            <select class="form-select" name="area_destino_id" id="area_destino_id" required>
              <option value="">Seleccione área</option>
              <?php $__currentLoopData = $areas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $area): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($area->id); ?>"><?php echo e($area->nombre); ?></option>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
          </div>

          <div class="mb-3">
            <label for="observacion" class="form-label">Observación</label>
            <textarea class="form-control" name="observacion" rows="3"></textarea>
          </div>

          <div class="mb-3">
            <label for="archivo_derivacion" class="form-label">Archivo (opcional)</label>
            <input type="file" class="form-control" name="archivo_derivacion" accept=".pdf,.docx,.png,.jpg">
          </div>
        </div>
        <div class="modal-footer">
          <button type="submit" class="btn btn-primary">Derivar</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
        </div>
      </div>
    </form>
  </div>
</div>


<!-- Modal Trazabilidad -->
<div class="modal fade" id="modalTrazabilidad" tabindex="-1" aria-labelledby="modalTrazabilidadLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Trazabilidad del Trámite</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <div id="contenidoTrazabilidad"></div>
      </div>
    </div>
  </div>
</div>




<!--end row-->


<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<!-- jQuery y DataTables -->

<!-- jQuery y DataTables -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

<!-- DataTables Buttons -->
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.colVis.min.js"></script>

<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.3.6/css/buttons.dataTables.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
    $(document).ready(function () {
        $("#tablaAreas").DataTable({
            "responsive": true,
            "lengthChange": true,
            "autoWidth": false,
            "buttons": [
                {
                    extend: 'collection',
                    text: 'Opciones',
                    buttons: [
                        { extend: 'copy', text: 'Copiar' },
                        { extend: 'csv', text: 'CSV' },
                        { extend: 'excel', text: 'Excel', title: 'Periodos Académicos' },
                        { extend: 'pdf', text: 'PDF' },
                        { extend: 'print', text: 'Imprimir' }
                    ]
                },
                { extend: 'colvis', text: 'Visibilidad de Columna' }
            ],
            "paging": true,
            "searching": true,
            "info": true,
            "language": {
                "search": "Buscar:",
                "lengthMenu": "Mostrar _MENU_ registros por página",
                "info": "Mostrando _START_ a _END_ de _TOTAL_ entradas",
                "paginate": {
                    "first": "Primero",
                    "previous": "Anterior",
                    "next": "Siguiente",
                    "last": "Último"
                }
            }
        }).buttons().container().appendTo('#tablaAreas_wrapper .col-md-6:eq(0)');
    });
</script>


<script>
    function derivarTramite(id) {
        $('#inputSolicitudId').val(id);
        $('#formDerivarTramite')[0].reset();
        $('#modalDerivar').modal('show');
    }

    $('#formDerivarTramite').submit(function (e) {
        e.preventDefault();

        Swal.fire({
            title: '¿Estás seguro?',
            text: "¿Deseas derivar este trámite?",
            icon: 'question',
            showCancelButton: true,
            confirmButtonText: 'Sí, derivar',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.isConfirmed) {
                let formData = new FormData(this);

                // Agregar token CSRF manualmente
                formData.append('_token', $('meta[name="csrf-token"]').attr('content'));

                $.ajax({
                    url: '<?php echo e(route("tramites.derivar")); ?>',
                    type: 'POST',
                    data: formData,
                    contentType: false,
                    processData: false,
                    success: function (res) {
                        Swal.fire('Éxito', res.message, 'success');
                        $('#modalDerivar').modal('hide');
                        setTimeout(() => location.reload(), 1000);
                    },
                    error: function (err) {
                        console.error(err);
                        Swal.fire('Error', 'No se pudo derivar el trámite.', 'error');
                    }
                });
            }
        });
    });
</script>



<script>
    function verTrazabilidad(solicitudId) {
        $('#contenidoTrazabilidad').html('<p>Cargando...</p>');
        $('#modalTrazabilidad').modal('show');

        $.get("<?php echo e(url('/tramites/trazabilidad')); ?>/" + solicitudId, function (res) {
            $('#contenidoTrazabilidad').html(res.html);
        }).fail(function () {
            $('#contenidoTrazabilidad').html('<div class="alert alert-danger">No se pudo cargar el historial.</div>');
        });
    }
</script>



<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dedu/public_html/iestpjuanhuarin.dedu.pe/resources/views/areas/tramites/index.blade.php ENDPATH**/ ?>