@if($historial->isEmpty())
    <p class="text-muted">No hay historial de derivaciones para este trámite.</p>
@else
    <ul class="timeline">
        @foreach($historial as $item)
            <li class="timeline-item mb-5">
                <h5 class="fw-bold">{{ $item->area_origen }} → {{ $item->area_destino }}</h5>
                <p class="text-muted mb-2"><i class="bi bi-clock"></i> {{ $item->fecha_derivacion }}</p>
                <p><strong>Estado origen:</strong> {{ ucfirst($item->estado_en_origen) }} |
                   <strong>Estado destino:</strong> {{ ucfirst($item->estado_en_destino) }}</p>
                <p><strong>Derivado por:</strong> {{ $item->usuario_nombre }}</p>
                @if($item->observacion)
                    <p><strong>Observación:</strong> {{ $item->observacion }}</p>
                @endif
                @if($item->archivo_derivacion)
                    <a href="{{ asset('tramites/derivaciones/' . $item->archivo_derivacion) }}" target="_blank" class="btn btn-sm btn-outline-secondary">
                        <i class="bi bi-file-earmark-text"></i> Ver documento adjunto
                    </a>
                @endif
            </li>
        @endforeach
    </ul>
@endif
