<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Role extends Model
{
    use HasFactory;

    protected $table = 'roles';

    protected $fillable = [
        'nombre',
        'descripcion',
        'estado', // Incluye el campo estado (1 = activo, 0 = inactivo)
    ];

    /**
     * Relación con los usuarios que tienen este rol.
     */
    public function usuarios()
    {
        return $this->belongsToMany(Usuario::class, 'usuario_roles', 'rol_id', 'usuario_id');
    }

    public function modulos()
{
    return $this->belongsToMany(Modulo::class, 'modulo_roles', 'rol_id', 'modulo_id')->withTimestamps();
}

}
