<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CursosPlanEstudio extends Model
{
    use HasFactory;

    // Nombre de la tabla en la base de datos
    protected $table = 'cursos_plan_estudio';

    // Campos que pueden ser asignados masivamente
    protected $fillable = [
        'curso_id',
        'plan_estudio_id',
    ];

    // Relación con el modelo Curso (un curso pertenece a varios planes de estudio)
    public function curso()
    {
        return $this->belongsTo(Curso::class, 'curso_id');
    }

    // Relación con el modelo PlanEstudio (un plan de estudio tiene muchos cursos)
    public function planEstudio()
    {
        return $this->belongsTo(PlanEstudio::class, 'plan_estudio_id');
    }
}
