<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Convalidacion extends Model
{
    use HasFactory;

    protected $table = 'convalidaciones';

    protected $fillable = [
        'estudiante_id',
        'curso_destino_id',
        'curso_origen',
        'institucion_origen',
        'nota_origen',
        'periodo_id',
        'fecha_convalidacion',
        'estado',
        'observaciones',
    ];

    // Relaciones
    public function estudiante()
    {
        return $this->belongsTo(Postulante::class, 'estudiante_id', 'id_postulante');
    }

    public function cursoDestino()
    {
        return $this->belongsTo(Curso::class, 'curso_destino_id');
    }

    public function periodo()
    {
        return $this->belongsTo(Periodo::class, 'periodo_id');
    }
}
